/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.cli;

import com.autojav.core.CodeParser;
import com.autojav.core.ConfigManager;
import com.autojav.core.TerminalUtils;
import com.autojav.core.ai.AIService;
import com.autojav.core.ai.AIServiceFactory;
import com.autojav.core.audit.AuditManager;
import com.autojav.core.audit.AuditResult;
import com.autojav.core.fix.FixManager;
import com.autojav.core.fix.FixResult;
import com.autojav.core.license.LicenseManager;
import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="audit", description={"\u4ee3\u7801\u5ba1\u8ba1\u4e0e\u81ea\u52a8\u4fee\u590d"})
public class AuditCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Java\u6587\u4ef6\u6216\u76ee\u5f55\u8def\u5f84"})
    private String path;
    @CommandLine.Option(names={"-r", "--recursive"}, description={"\u9012\u5f52\u5904\u7406\u76ee\u5f55"})
    private boolean recursive;
    @CommandLine.Option(names={"-f", "--fix"}, description={"\u81ea\u52a8\u4fee\u590d\u95ee\u9898"})
    private boolean fix;
    @CommandLine.Option(names={"-o", "--output"}, description={"\u5ba1\u8ba1\u7ed3\u679c\u8f93\u51fa\u6587\u4ef6"})
    private String output;
    @CommandLine.Option(names={"-ai", "--use-ai"}, description={"\u4f7f\u7528AI\u8fdb\u884c\u6df1\u5ea6\u5ba1\u8ba1"})
    private boolean useAI;
    @CommandLine.Option(names={"-p", "--preview"}, description={"\u9884\u89c8\u4fee\u590d\u7ed3\u679c\uff0c\u4e0d\u5b9e\u9645\u4fee\u6539\u6587\u4ef6"})
    private boolean preview;
    private LicenseManager licenseManager;

    @Override
    public Integer call() throws Exception {
        this.licenseManager = new LicenseManager();
        TerminalUtils.printInfo("\u5f00\u59cb\u5ba1\u8ba1: " + this.path);
        TerminalUtils.printInfo("\u9012\u5f52\u5904\u7406: " + this.recursive);
        TerminalUtils.printInfo("\u81ea\u52a8\u4fee\u590d: " + this.fix);
        TerminalUtils.printInfo("\u4f7f\u7528AI: " + this.useAI);
        TerminalUtils.printInfo("\u9884\u89c8\u4fee\u590d: " + this.preview);
        if (this.output != null) {
            TerminalUtils.printInfo("\u8f93\u51fa\u6587\u4ef6: " + this.output);
        }
        if (this.useAI && !this.licenseManager.checkAndApplyRestriction("ai.audit")) {
            return 1;
        }
        if (this.fix && !this.licenseManager.checkAndApplyRestriction("code.fix")) {
            return 1;
        }
        CodeParser parser = new CodeParser();
        AuditManager auditManager = new AuditManager();
        File target = new File(this.path);
        if (target.isFile()) {
            CompilationUnit cu = parser.parseFile(target);
            if (cu != null) {
                TerminalUtils.printSuccess("\u6587\u4ef6\u89e3\u6790\u6210\u529f: " + target.getName());
                TerminalUtils.printInfo("\u7c7b\u6570\u91cf: " + parser.extractClasses(cu).size());
                TerminalUtils.printInfo("\u65b9\u6cd5\u6570\u91cf: " + parser.extractMethods(cu).size());
                List<AuditResult> results = auditManager.audit(cu);
                this.printAuditResults(results);
                if (this.useAI) {
                    this.performAIAudit(target);
                }
                if (this.fix) {
                    this.performFix(target, results);
                }
            } else {
                TerminalUtils.printError("\u6587\u4ef6\u89e3\u6790\u5931\u8d25: " + target.getName());
            }
        } else if (target.isDirectory()) {
            File firstFile;
            List<CompilationUnit> compilationUnits = parser.parseDirectory(target, this.recursive);
            TerminalUtils.printSuccess("\u76ee\u5f55\u89e3\u6790\u5b8c\u6210\uff0c\u5171\u89e3\u6790 " + compilationUnits.size() + " \u4e2aJava\u6587\u4ef6");
            List<AuditResult> results = auditManager.audit(compilationUnits);
            this.printAuditResults(results);
            if (this.useAI && !compilationUnits.isEmpty() && (firstFile = (File)compilationUnits.get(0).getStorage().map(s -> s.getPath().toFile()).orElse(null)) != null) {
                this.performAIAudit(firstFile);
            }
            if (this.fix && !compilationUnits.isEmpty() && (firstFile = (File)compilationUnits.get(0).getStorage().map(s -> s.getPath().toFile()).orElse(null)) != null) {
                List<AuditResult> fileResults = results.stream().filter(r -> r.getFilePath().contains(firstFile.getName())).collect(Collectors.toList());
                this.performFix(firstFile, fileResults);
            }
        } else {
            TerminalUtils.printError("\u65e0\u6548\u7684\u8def\u5f84: " + this.path);
            return 1;
        }
        return 0;
    }

    private void performAIAudit(File file) throws Exception {
        TerminalUtils.printInfo("\u5f00\u59cbAI\u6df1\u5ea6\u5ba1\u8ba1...");
        ConfigManager configManager = new ConfigManager();
        String apiKey = configManager.get("ai.api.key");
        if (apiKey == null || apiKey.isEmpty()) {
            TerminalUtils.printError("\u672a\u914d\u7f6eAI API\u5bc6\u94a5\uff0c\u8bf7\u5148\u4f7f\u7528 config set ai.api.key <your-api-key> \u8bbe\u7f6e");
            return;
        }
        String code = Files.readString(file.toPath());
        AIService aiService = AIServiceFactory.createAIService(apiKey);
        String rules = "\u57fa\u4e8e\u963f\u91cc\u5df4\u5df4Java\u5f00\u53d1\u89c4\u8303\uff0c\u68c0\u67e5\u4ee5\u4e0b\u95ee\u9898\uff1a\n1. \u7a7a\u6307\u9488\u5f02\u5e38\u98ce\u9669\n2. SQL\u6ce8\u5165\u98ce\u9669\n3. \u4ee3\u7801\u89c4\u8303\u95ee\u9898\n4. \u6027\u80fd\u95ee\u9898\n5. \u5b89\u5168\u95ee\u9898";
        try {
            String aiResult = aiService.auditCode(code, rules);
            TerminalUtils.printSuccess("AI\u5ba1\u8ba1\u5b8c\u6210:");
            TerminalUtils.printInfo(aiResult);
        }
        catch (Exception e) {
            TerminalUtils.printError("AI\u5ba1\u8ba1\u5931\u8d25: " + e.getMessage());
        }
    }

    private void performFix(File file, List<AuditResult> results) throws Exception {
        if (results.isEmpty()) {
            TerminalUtils.printSuccess("\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u4fee\u590d\u7684\u95ee\u9898");
            return;
        }
        TerminalUtils.printInfo("\u5f00\u59cb\u4ee3\u7801\u4fee\u590d...");
        ConfigManager configManager = new ConfigManager();
        String apiKey = configManager.get("ai.api.key");
        if (apiKey == null || apiKey.isEmpty()) {
            TerminalUtils.printError("\u672a\u914d\u7f6eAI API\u5bc6\u94a5\uff0c\u8bf7\u5148\u4f7f\u7528 config set ai.api.key <your-api-key> \u8bbe\u7f6e");
            return;
        }
        StringBuilder issuesBuilder = new StringBuilder();
        for (AuditResult result : results) {
            issuesBuilder.append("- ").append(result.getMessage()).append("\n");
        }
        String issues = issuesBuilder.toString();
        FixManager fixManager = new FixManager(apiKey);
        FixResult fixResult = fixManager.fixCode(file, issues, this.preview);
        fixManager.showPreview(fixResult);
        if (!this.preview) {
            TerminalUtils.printInfo("\u662f\u5426\u5e94\u7528\u4fee\u590d\uff1f(y/n): ");
            Scanner scanner = new Scanner(System.in);
            String input = scanner.nextLine();
            if (input.equalsIgnoreCase("y")) {
                TerminalUtils.printSuccess("\u4fee\u590d\u5df2\u5e94\u7528\uff0c\u5907\u4efd\u6587\u4ef6: " + fixResult.getBackupFile().getName());
            } else {
                fixManager.rollback(fixResult);
                TerminalUtils.printInfo("\u4fee\u590d\u5df2\u53d6\u6d88");
            }
        }
    }

    private void printAuditResults(List<AuditResult> results) {
        if (results.isEmpty()) {
            TerminalUtils.printSuccess("\u672a\u53d1\u73b0\u95ee\u9898");
            return;
        }
        TerminalUtils.printInfo("\u5ba1\u8ba1\u7ed3\u679c\uff08\u5171 " + results.size() + " \u4e2a\u95ee\u9898\uff09:");
        for (AuditResult result : results) {
            switch (result.getSeverity()) {
                case ERROR: {
                    TerminalUtils.printError(result.toString());
                    break;
                }
                case WARNING: {
                    TerminalUtils.printWarning(result.toString());
                    break;
                }
                case INFO: {
                    TerminalUtils.printInfo(result.toString());
                }
            }
        }
    }
}

