/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.cli;

import com.autojav.core.ConfigManager;
import com.autojav.core.TerminalUtils;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="config", description={"\u914d\u7f6e\u7ba1\u7406"})
public class ConfigCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"\u914d\u7f6e\u64cd\u4f5c: set, get, list"})
    private String operation;
    @CommandLine.Parameters(index="1", description={"\u914d\u7f6e\u952e"}, arity="0..1")
    private String key;
    @CommandLine.Parameters(index="2", description={"\u914d\u7f6e\u503c"}, arity="0..1")
    private String value;
    @CommandLine.Option(names={"-g", "--global"}, description={"\u4f7f\u7528\u5168\u5c40\u914d\u7f6e"})
    private boolean global;

    @Override
    public Integer call() throws Exception {
        ConfigManager configManager = new ConfigManager(this.global);
        switch (this.operation.toLowerCase()) {
            case "set": {
                if (this.key == null || this.value == null) {
                    TerminalUtils.printError("set\u64cd\u4f5c\u9700\u8981\u6307\u5b9a\u914d\u7f6e\u952e\u548c\u503c");
                    return 1;
                }
                configManager.set(this.key, this.value);
                configManager.save(this.global);
                TerminalUtils.printSuccess("\u914d\u7f6e\u5df2\u4fdd\u5b58: " + this.key + " = " + this.value);
                break;
            }
            case "get": {
                if (this.key == null) {
                    TerminalUtils.printError("get\u64cd\u4f5c\u9700\u8981\u6307\u5b9a\u914d\u7f6e\u952e");
                    return 1;
                }
                String configValue = configManager.get(this.key);
                if (configValue != null) {
                    TerminalUtils.printInfo(this.key + " = " + configValue);
                    break;
                }
                TerminalUtils.printWarning("\u914d\u7f6e\u952e\u4e0d\u5b58\u5728: " + this.key);
                break;
            }
            case "list": {
                TerminalUtils.printInfo("\u5f53\u524d\u914d\u7f6e:");
                configManager.list();
                break;
            }
            default: {
                TerminalUtils.printError("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c: " + this.operation);
                return 1;
            }
        }
        return 0;
    }
}

