/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.cli;

import com.autojav.core.CodeParser;
import com.autojav.core.TerminalUtils;
import com.autojav.core.doc.DocGenerationException;
import com.autojav.core.doc.DocGenerator;
import com.autojav.core.doc.DocGeneratorFactory;
import com.autojav.core.license.LicenseManager;
import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"\u81ea\u52a8\u751f\u6210\u63a5\u53e3\u6587\u6863"})
public class DocCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Java\u6587\u4ef6\u6216\u76ee\u5f55\u8def\u5f84"})
    private String path;
    @CommandLine.Option(names={"-f", "--format"}, defaultValue="markdown", description={"\u6587\u6863\u683c\u5f0f: markdown, openapi"})
    private String format;
    @CommandLine.Option(names={"-o", "--output"}, description={"\u6587\u6863\u8f93\u51fa\u6587\u4ef6\u6216\u76ee\u5f55"})
    private String output;
    @CommandLine.Option(names={"-t", "--template"}, description={"\u81ea\u5b9a\u4e49\u6a21\u677f\u6587\u4ef6"})
    private String template;
    @CommandLine.Option(names={"-r", "--recursive"}, description={"\u9012\u5f52\u5904\u7406\u76ee\u5f55"})
    private boolean recursive;
    private LicenseManager licenseManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() throws Exception {
        List<CompilationUnit> compilationUnits;
        this.licenseManager = new LicenseManager();
        TerminalUtils.printInfo("\u5f00\u59cb\u751f\u6210\u6587\u6863: " + this.path);
        TerminalUtils.printInfo("\u6587\u6863\u683c\u5f0f: " + this.format);
        TerminalUtils.printInfo("\u9012\u5f52\u5904\u7406: " + this.recursive);
        if (this.output != null) {
            TerminalUtils.printInfo("\u8f93\u51fa\u8def\u5f84: " + this.output);
        }
        if (this.template != null) {
            TerminalUtils.printInfo("\u81ea\u5b9a\u4e49\u6a21\u677f: " + this.template);
        }
        if (this.template != null && !this.licenseManager.checkAndApplyRestriction("custom.template")) {
            return 1;
        }
        CodeParser parser = new CodeParser();
        File target = new File(this.path);
        if (target.isFile()) {
            CompilationUnit cu = parser.parseFile(target);
            if (cu == null) {
                TerminalUtils.printError("\u6587\u4ef6\u89e3\u6790\u5931\u8d25: " + target.getName());
                return 1;
            }
            compilationUnits = List.of(cu);
            TerminalUtils.printSuccess("\u6587\u4ef6\u89e3\u6790\u6210\u529f: " + target.getName());
        } else {
            if (!target.isDirectory()) {
                TerminalUtils.printError("\u65e0\u6548\u7684\u8def\u5f84: " + this.path);
                return 1;
            }
            compilationUnits = parser.parseDirectory(target, this.recursive);
            TerminalUtils.printSuccess("\u76ee\u5f55\u89e3\u6790\u5b8c\u6210\uff0c\u5171\u89e3\u6790 " + compilationUnits.size() + " \u4e2aJava\u6587\u4ef6");
        }
        DocGenerator docGenerator = DocGeneratorFactory.createDocGenerator(this.format);
        if (this.output != null) {
            File outputFile = new File(this.output);
            if (outputFile.getParentFile() != null && !outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            try {
                docGenerator.generateAndSave(compilationUnits, outputFile);
                TerminalUtils.printSuccess("\u6587\u6863\u5df2\u4fdd\u5b58\u5230: " + outputFile.getAbsolutePath());
                return 0;
            }
            catch (DocGenerationException e) {
                TerminalUtils.printError("\u4fdd\u5b58\u6587\u6863\u5931\u8d25: " + e.getMessage());
                return 1;
            }
        }
        try {
            String docContent = docGenerator.generate(compilationUnits);
            TerminalUtils.printSuccess("\u6587\u6863\u751f\u6210\u6210\u529f");
            System.out.println(docContent);
            return 0;
        }
        catch (DocGenerationException e) {
            TerminalUtils.printError("\u6587\u6863\u751f\u6210\u5931\u8d25: " + e.getMessage());
            return 1;
        }
    }
}

