/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.cli;

import com.autojav.core.TerminalUtils;
import com.autojav.core.license.LicenseManager;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="license", description={"\u8bb8\u53ef\u8bc1\u7ba1\u7406"})
public class LicenseCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"\u8bb8\u53ef\u8bc1\u64cd\u4f5c: activate, info, trial"})
    private String operation;
    @CommandLine.Parameters(index="1", description={"\u8bb8\u53ef\u8bc1\u5bc6\u94a5"}, arity="0..1")
    private String licenseKey;

    @Override
    public Integer call() throws Exception {
        LicenseManager licenseManager = new LicenseManager();
        switch (this.operation.toLowerCase()) {
            case "activate": {
                if (this.licenseKey == null) {
                    TerminalUtils.printError("\u6fc0\u6d3b\u64cd\u4f5c\u9700\u8981\u6307\u5b9a\u8bb8\u53ef\u8bc1\u5bc6\u94a5");
                    return 1;
                }
                boolean activated = licenseManager.activateLicense(this.licenseKey);
                return activated ? 0 : 1;
            }
            case "info": {
                licenseManager.showLicenseInfo();
                return 0;
            }
            case "trial": {
                boolean trialStarted = licenseManager.startTrialFromCommand();
                return trialStarted ? 0 : 1;
            }
        }
        TerminalUtils.printError("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c: " + this.operation);
        return 1;
    }
}

