/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeParser {
    private static final Logger log = LoggerFactory.getLogger(CodeParser.class);
    private JavaParser javaParser = new JavaParser();

    public CompilationUnit parseFile(File file) throws IOException {
        if (!(file.exists() && file.isFile() && file.getName().endsWith(".java"))) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684Java\u6587\u4ef6: " + file.getAbsolutePath());
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ParseResult<CompilationUnit> result = this.javaParser.parse(fis);
            if (result.isSuccessful()) {
                log.debug("\u6587\u4ef6\u89e3\u6790\u6210\u529f: {}", (Object)file.getAbsolutePath());
                CompilationUnit compilationUnit = result.getResult().orElse(null);
                return compilationUnit;
            }
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25: {}", (Object)file.getAbsolutePath());
            result.getProblems().forEach(problem -> log.error("\u89e3\u6790\u95ee\u9898: {}", (Object)problem.getMessage()));
            CompilationUnit compilationUnit = null;
            return compilationUnit;
        }
    }

    public List<CompilationUnit> parseDirectory(File directory, boolean recursive) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u76ee\u5f55: " + directory.getAbsolutePath());
        }
        ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();
        this.parseDirectoryRecursive(directory, recursive, compilationUnits);
        return compilationUnits;
    }

    private void parseDirectoryRecursive(File directory, boolean recursive, List<CompilationUnit> compilationUnits) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".java")) {
                CompilationUnit cu;
                if (file.getName().endsWith("Test.java") || file.getName().endsWith("Tests.java") || (cu = this.parseFile(file)) == null) continue;
                compilationUnits.add(cu);
                continue;
            }
            if (!file.isDirectory() || !recursive) continue;
            this.parseDirectoryRecursive(file, recursive, compilationUnits);
        }
    }

    public List<ClassOrInterfaceDeclaration> extractClasses(CompilationUnit cu) {
        final ArrayList<ClassOrInterfaceDeclaration> classes = new ArrayList<ClassOrInterfaceDeclaration>();
        cu.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, Void arg) {
                super.visit(n, arg);
                classes.add(n);
            }
        }, null);
        return classes;
    }

    public List<MethodDeclaration> extractMethods(CompilationUnit cu) {
        final ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        cu.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(MethodDeclaration n, Void arg) {
                super.visit(n, arg);
                methods.add(n);
            }
        }, null);
        return methods;
    }

    public List<MethodCallExpr> extractMethodCalls(CompilationUnit cu) {
        final ArrayList<MethodCallExpr> methodCalls = new ArrayList<MethodCallExpr>();
        cu.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(MethodCallExpr n, Void arg) {
                super.visit(n, arg);
                methodCalls.add(n);
            }
        }, null);
        return methodCalls;
    }

    public List<Parameter> extractParameters(MethodDeclaration method) {
        return method.getParameters();
    }

    public int getLineCount(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int n;
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((n = fis.read(buffer)) > 0) {
                for (int i = 0; i < n; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
            int n2 = count;
            return n2;
        }
    }

    public static void main(String[] args2) {
        CodeParser parser = new CodeParser();
        try {
            File testFile = new File("src/main/java/com/autojav/cli/Main.java");
            CompilationUnit cu = parser.parseFile(testFile);
            if (cu != null) {
                System.out.println("\u6587\u4ef6\u89e3\u6790\u6210\u529f");
                System.out.println("\u7c7b\u6570\u91cf: " + parser.extractClasses(cu).size());
                System.out.println("\u65b9\u6cd5\u6570\u91cf: " + parser.extractMethods(cu).size());
            }
        }
        catch (IOException e) {
            log.error("\u6d4b\u8bd5\u89e3\u6790\u5931\u8d25", e);
        }
    }
}

