/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static final String CONFIG_FILE_NAME = ".autojav.properties";
    private static final String GLOBAL_CONFIG_DIR = System.getProperty("user.home") + File.separator + ".autojav";
    private static final String LOCAL_CONFIG_DIR = ".";
    private Properties properties = new Properties();

    public ConfigManager() {
        this.loadConfig(false);
    }

    public ConfigManager(boolean global) {
        this.loadConfig(global);
    }

    private void loadConfig(boolean global) {
        block8: {
            String configDir = global ? GLOBAL_CONFIG_DIR : LOCAL_CONFIG_DIR;
            File configFile = new File(configDir, CONFIG_FILE_NAME);
            try {
                if (configFile.exists()) {
                    try (FileInputStream fis = new FileInputStream(configFile);){
                        this.properties.load(fis);
                        log.debug("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f: {}", (Object)configFile.getAbsolutePath());
                        break block8;
                    }
                }
                log.debug("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)configFile.getAbsolutePath());
            }
            catch (IOException e) {
                log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
            }
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void save(boolean global) throws IOException {
        String configDir = global ? GLOBAL_CONFIG_DIR : LOCAL_CONFIG_DIR;
        File configDirFile = new File(configDir);
        if (!configDirFile.exists()) {
            configDirFile.mkdirs();
        }
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        try (FileOutputStream fos = new FileOutputStream(configFile);){
            this.properties.store(fos, "AutoJava CLI Configuration");
            log.debug("\u914d\u7f6e\u6587\u4ef6\u4fdd\u5b58\u6210\u529f: {}", (Object)configFile.getAbsolutePath());
        }
    }

    public void list() {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.out.println(k + " = " + v)));
    }

    public static void main(String[] args2) {
        ConfigManager configManager = new ConfigManager();
        configManager.list();
    }
}

