/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core;

import com.autojav.core.TerminalUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);

    public static int handleException(Exception e) {
        log.error("\u53d1\u751f\u5f02\u5e38", e);
        if (e instanceof IllegalArgumentException) {
            TerminalUtils.printError("\u53c2\u6570\u9519\u8bef: " + e.getMessage());
            return 1;
        }
        if (e instanceof IOException) {
            TerminalUtils.printError("IO\u9519\u8bef: " + e.getMessage());
            return 2;
        }
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            TerminalUtils.printError("\u6267\u884c\u9519\u8bef: " + targetException.getMessage());
            return 3;
        }
        TerminalUtils.printError("\u672a\u77e5\u9519\u8bef: " + e.getMessage());
        return 99;
    }

    public static int handleRuntimeException(RuntimeException e) {
        log.error("\u53d1\u751f\u8fd0\u884c\u65f6\u5f02\u5e38", e);
        TerminalUtils.printError("\u8fd0\u884c\u65f6\u9519\u8bef: " + e.getMessage());
        return 4;
    }

    public static int handleError(Error e) {
        log.error("\u53d1\u751f\u4e25\u91cd\u9519\u8bef", e);
        TerminalUtils.printError("\u4e25\u91cd\u9519\u8bef: " + e.getMessage());
        return 999;
    }

    public static void printStackTrace(Exception e) {
        e.printStackTrace();
    }
}

