/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core;

public class TerminalUtils {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    public static final String BLACK_BG = "\u001b[40m";
    public static final String RED_BG = "\u001b[41m";
    public static final String GREEN_BG = "\u001b[42m";
    public static final String YELLOW_BG = "\u001b[43m";
    public static final String BLUE_BG = "\u001b[44m";
    public static final String PURPLE_BG = "\u001b[45m";
    public static final String CYAN_BG = "\u001b[46m";
    public static final String WHITE_BG = "\u001b[47m";
    public static final String BOLD = "\u001b[1m";
    public static final String UNDERLINE = "\u001b[4m";
    public static final String ITALIC = "\u001b[3m";

    public static void printColored(String text, String color) {
        System.out.print(color + text + RESET);
    }

    public static void printlnColored(String text, String color) {
        System.out.println(color + text + RESET);
    }

    public static void printSuccess(String message) {
        TerminalUtils.printlnColored(message, GREEN);
    }

    public static void printError(String message) {
        TerminalUtils.printlnColored(message, RED);
    }

    public static void printWarning(String message) {
        TerminalUtils.printlnColored(message, YELLOW);
    }

    public static void printInfo(String message) {
        TerminalUtils.printlnColored(message, BLUE);
    }

    public static void printBold(String message) {
        TerminalUtils.printlnColored(message, BOLD);
    }

    public static boolean isAnsiSupported() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String osVersion = System.getProperty("os.version");
            try {
                double version = Double.parseDouble(osVersion);
                return version >= 10.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

