/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.ai;

import com.autojav.core.ai.AIService;
import com.autojav.core.ai.LangChain4jAIService;

public class AIServiceFactory {
    public static AIService createAIService(String serviceType, String apiKey) {
        switch (serviceType.toLowerCase()) {
            case "qwen": 
            case "tongyi": 
            case "aliyun": {
                System.setProperty("ai.provider", "qwen");
                return new LangChain4jAIService(apiKey);
            }
            case "ernie": 
            case "baidu": {
                System.setProperty("ai.provider", "ernie");
                return new LangChain4jAIService(apiKey);
            }
            case "spark": 
            case "xfyun": {
                System.setProperty("ai.provider", "spark");
                return new LangChain4jAIService(apiKey);
            }
            case "kimi": 
            case "moonshot": {
                System.setProperty("ai.provider", "kimi");
                return new LangChain4jAIService(apiKey);
            }
        }
        return new LangChain4jAIService(apiKey);
    }

    public static AIService createAIService(String apiKey) {
        return AIServiceFactory.createAIService("kimi", apiKey);
    }

    public static AIService createAIServiceWithServiceType(String serviceType) {
        switch (serviceType.toLowerCase()) {
            case "qwen": 
            case "tongyi": 
            case "aliyun": {
                System.setProperty("ai.provider", "qwen");
                return new LangChain4jAIService();
            }
            case "ernie": 
            case "baidu": {
                System.setProperty("ai.provider", "ernie");
                return new LangChain4jAIService();
            }
            case "spark": 
            case "xfyun": {
                System.setProperty("ai.provider", "spark");
                return new LangChain4jAIService();
            }
            case "kimi": 
            case "moonshot": {
                System.setProperty("ai.provider", "kimi");
                return new LangChain4jAIService();
            }
        }
        return new LangChain4jAIService();
    }

    public static AIService createAIService() {
        return AIServiceFactory.createAIServiceWithServiceType("kimi");
    }
}

