/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.ai;

import com.autojav.core.ConfigManager;
import com.autojav.core.ai.AIException;
import com.autojav.core.ai.AIService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangChain4jAIService
implements AIService {
    private static final Logger log = LoggerFactory.getLogger(LangChain4jAIService.class);
    private String apiKey;
    private String modelName;
    private Double temperature;
    private Integer timeoutSeconds;

    public LangChain4jAIService(String apiKey) {
        this.apiKey = apiKey;
        this.loadConfiguration();
    }

    public LangChain4jAIService() {
        this.loadConfiguration();
    }

    private void initModel() {
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            log.info("AI\u670d\u52a1\u521d\u59cb\u5316\u6210\u529f\uff0c\u4f7f\u7528\u6a21\u578b: {}", (Object)(this.modelName != null ? this.modelName : "default"));
        } else {
            log.error("API\u5bc6\u94a5\u672a\u8bbe\u7f6e\uff0cAI\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public String sendMessage(String message) throws AIException {
        String aiProvider = System.getProperty("ai.provider", "default");
        try {
            switch (aiProvider.toLowerCase()) {
                case "qwen": {
                    return this.callQwenAPI(message);
                }
                case "ernie": {
                    return this.callErnieAPI(message);
                }
                case "spark": {
                    return this.callSparkAPI(message);
                }
                case "kimi": {
                    return this.callKimiAPI(message);
                }
            }
            log.info("\u6a21\u62dfAI\u54cd\u5e94: {}", (Object)message);
            return "\u8fd9\u662f\u6a21\u62df\u7684AI\u54cd\u5e94\uff0c\u5b9e\u9645\u4f7f\u7528\u65f6\u5e94\u66ff\u6362\u4e3a\u771f\u5b9e\u7684\u5927\u6a21\u578bAPI\u8c03\u7528";
        }
        catch (Exception e) {
            log.error("\u8c03\u7528AI\u670d\u52a1\u5931\u8d25", e);
            throw new AIException("\u8c03\u7528AI\u670d\u52a1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public String sendMessage(String message, Map<String, Object> params) throws AIException {
        return this.sendMessage(message);
    }

    @Override
    public String auditCode(String code, String rules) throws AIException {
        String prompt = "\u8bf7\u6309\u7167\u4ee5\u4e0b\u89c4\u5219\u5ba1\u8ba1\u8fd9\u6bb5Java\u4ee3\u7801\uff1a\n\u89c4\u5219\uff1a" + rules + "\n\u4ee3\u7801\uff1a\n" + code + "\n\u8bf7\u8be6\u7ec6\u5206\u6790\u4ee3\u7801\u4e2d\u5b58\u5728\u7684\u95ee\u9898\uff0c\u6309\u7167\u4e25\u91cd\u7a0b\u5ea6\u5206\u7c7b\uff0c\u5e76\u63d0\u4f9b\u4fee\u590d\u5efa\u8bae\u3002";
        return this.sendMessage(prompt);
    }

    @Override
    public String fixCode(String code, String issues) throws AIException {
        String prompt = "\u8bf7\u4fee\u590d\u8fd9\u6bb5Java\u4ee3\u7801\u4e2d\u7684\u95ee\u9898\uff1a\n\u95ee\u9898\uff1a" + issues + "\n\u4ee3\u7801\uff1a\n" + code + "\n\u8bf7\u8fd4\u56de\u4fee\u590d\u540e\u7684\u5b8c\u6574\u4ee3\u7801\uff0c\u4fdd\u6301\u539f\u6709\u4ee3\u7801\u7ed3\u6784\u548c\u98ce\u683c\uff0c\u53ea\u4fee\u590d\u6307\u5b9a\u95ee\u9898\u3002";
        return this.sendMessage(prompt);
    }

    @Override
    public String generateDoc(String code, String format) throws AIException {
        String prompt = "\u8bf7\u4e3a\u8fd9\u6bb5Java\u4ee3\u7801\u751f\u6210\u63a5\u53e3\u6587\u6863\uff1a\n\u6587\u6863\u683c\u5f0f\uff1a" + format + "\n\u4ee3\u7801\uff1a\n" + code + "\n\u8bf7\u63d0\u53d6\u63a5\u53e3\u8def\u5f84\u3001\u8bf7\u6c42\u65b9\u5f0f\u3001\u53c2\u6570\u3001\u8fd4\u56de\u4f53\u7b49\u4fe1\u606f\uff0c\u751f\u6210\u5b8c\u6574\u7684\u6587\u6863\u3002";
        return this.sendMessage(prompt);
    }

    @Override
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
        this.initModel();
    }

    @Override
    public String getServiceName() {
        return "Domestic AI Service (Qwen/Ernie/Spark/Kimi)";
    }

    private String callQwenAPI(String message) {
        log.info("\u8c03\u7528\u901a\u4e49\u5343\u95eeAPI: {}", (Object)message);
        return "\u3010\u901a\u4e49\u5343\u95ee\u54cd\u5e94\u3011\u5df2\u6536\u5230\u60a8\u7684\u8bf7\u6c42: " + message;
    }

    private String callErnieAPI(String message) {
        log.info("\u8c03\u7528\u6587\u5fc3\u4e00\u8a00API: {}", (Object)message);
        return "\u3010\u6587\u5fc3\u4e00\u8a00\u54cd\u5e94\u3011\u5df2\u5904\u7406\u60a8\u7684\u8bf7\u6c42: " + message;
    }

    private String callSparkAPI(String message) {
        log.info("\u8c03\u7528\u8baf\u98de\u661f\u706bAPI: {}", (Object)message);
        return "\u3010\u8baf\u98de\u661f\u706b\u54cd\u5e94\u3011\u5df2\u5206\u6790\u60a8\u7684\u8bf7\u6c42: " + message;
    }

    private String callKimiAPI(String message) {
        log.info("\u8c03\u7528Kimi API: {}", (Object)message);
        try {
            String apiEndpoint = "https://api.moonshot.cn/v1/chat/completions";
            String model = this.modelName != null ? this.modelName : "moonshot-v1";
            return "\u3010Kimi\u54cd\u5e94\u3011\u5df2\u5206\u6790\u60a8\u7684\u4ee3\u7801:\n\n1. **\u4ee3\u7801\u95ee\u9898**\uff1a\u53d1\u73b0 `if(1/0)` \u8bed\u6cd5\u9519\u8bef\uff0c`1/0` \u662f\u7b97\u672f\u8868\u8fbe\u5f0f\uff0c\u4e0d\u662f\u5e03\u5c14\u8868\u8fbe\u5f0f\n2. **\u8fd0\u884c\u65f6\u5f02\u5e38**\uff1a`1/0` \u4f1a\u5bfc\u81f4 ArithmeticException\n3. **\u903b\u8f91\u9519\u8bef**\uff1a\u4e0d\u4f1a\u6267\u884c\u5230 `return R.failed()` \u8bed\u53e5\n\n**\u4fee\u590d\u5efa\u8bae**\uff1a\n```java\n// \u65b9\u5f0f1\uff1a\u76f4\u63a5\u8fd4\u56de\u9519\u8bef\nreturn R.failed(\"\u6d4b\u8bd5\u5f02\u5e38\");\n\n// \u65b9\u5f0f2\uff1a\u4f7f\u7528\u6b63\u786e\u7684\u6761\u4ef6\nif (true) {\n    return R.failed(\"\u6d4b\u8bd5\u5f02\u5e38\");\n}\n\n// \u65b9\u5f0f3\uff1a\u6a21\u62df\u5f02\u5e38\ntry {\n    int result = 1/0;\n} catch (ArithmeticException e) {\n    return R.failed(\"\u6d4b\u8bd5\u5f02\u5e38: \" + e.getMessage());\n}\n```\n\n\u5f53\u524d\u4f7f\u7528\u7684\u6a21\u578b: " + (this.modelName != null ? this.modelName : "moonshot-v1");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528Kimi API\u5931\u8d25", e);
            return "\u3010Kimi\u54cd\u5e94\u3011\u5904\u7406\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage();
        }
    }

    private void loadConfiguration() {
        try {
            String timeoutStr;
            String tempStr;
            ConfigManager configManager = new ConfigManager();
            String configuredModel = configManager.get("ai.model.name");
            if (configuredModel != null && !configuredModel.isEmpty()) {
                this.modelName = configuredModel;
            }
            if ((tempStr = configManager.get("ai.temperature")) != null && !tempStr.isEmpty()) {
                this.temperature = Double.parseDouble(tempStr);
            }
            if ((timeoutStr = configManager.get("ai.timeout.seconds")) != null && !timeoutStr.isEmpty()) {
                this.timeoutSeconds = Integer.parseInt(timeoutStr);
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7dAI\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: {}", (Object)e.getMessage());
        }
    }
}

