/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.audit;

import com.autojav.core.audit.AuditResult;
import com.autojav.core.audit.AuditRule;
import com.autojav.core.audit.rules.NullPointerExceptionRule;
import com.autojav.core.audit.rules.SqlInjectionRule;
import com.github.javaparser.ast.CompilationUnit;
import java.util.ArrayList;
import java.util.List;

public class AuditManager {
    private List<AuditRule> rules = new ArrayList<AuditRule>();

    public AuditManager() {
        this.initRules();
    }

    private void initRules() {
        this.rules.add(new NullPointerExceptionRule());
        this.rules.add(new SqlInjectionRule());
    }

    public List<AuditResult> audit(CompilationUnit compilationUnit) {
        ArrayList<AuditResult> results = new ArrayList<AuditResult>();
        for (AuditRule rule : this.rules) {
            results.addAll(rule.audit(compilationUnit));
        }
        return results;
    }

    public List<AuditResult> audit(List<CompilationUnit> compilationUnits) {
        ArrayList<AuditResult> results = new ArrayList<AuditResult>();
        for (CompilationUnit compilationUnit : compilationUnits) {
            results.addAll(this.audit(compilationUnit));
        }
        return results;
    }

    public List<AuditRule> getRules() {
        return this.rules;
    }

    public void addRule(AuditRule rule) {
        this.rules.add(rule);
    }

    public void removeRule(AuditRule rule) {
        this.rules.remove(rule);
    }
}

