/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.audit;

import com.autojav.core.audit.AuditRule;

public class AuditResult {
    private String ruleName;
    private AuditRule.Severity severity;
    private String message;
    private String filePath;
    private int line;
    private int column;
    private String fixSuggestion;

    public AuditResult(String ruleName, AuditRule.Severity severity, String message, String filePath, int line, int column, String fixSuggestion) {
        this.ruleName = ruleName;
        this.severity = severity;
        this.message = message;
        this.filePath = filePath;
        this.line = line;
        this.column = column;
        this.fixSuggestion = fixSuggestion;
    }

    public AuditResult(String ruleName, AuditRule.Severity severity, String message, String filePath, int line, int column) {
        this(ruleName, severity, message, filePath, line, column, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append((Object)this.severity).append("] ");
        sb.append(this.ruleName).append(": ");
        sb.append(this.message).append(" ");
        sb.append("(").append(this.filePath).append(":").append(this.line).append(":").append(this.column).append(")");
        if (this.fixSuggestion != null) {
            sb.append(" \u5efa\u8bae: ").append(this.fixSuggestion);
        }
        return sb.toString();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public AuditRule.Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getFixSuggestion() {
        return this.fixSuggestion;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public void setSeverity(AuditRule.Severity severity) {
        this.severity = severity;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setFixSuggestion(String fixSuggestion) {
        this.fixSuggestion = fixSuggestion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditResult)) {
            return false;
        }
        AuditResult other = (AuditResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        String this$ruleName = this.getRuleName();
        String other$ruleName = other.getRuleName();
        if (this$ruleName == null ? other$ruleName != null : !this$ruleName.equals(other$ruleName)) {
            return false;
        }
        AuditRule.Severity this$severity = this.getSeverity();
        AuditRule.Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$fixSuggestion = this.getFixSuggestion();
        String other$fixSuggestion = other.getFixSuggestion();
        return !(this$fixSuggestion == null ? other$fixSuggestion != null : !this$fixSuggestion.equals(other$fixSuggestion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        result = result * 59 + this.getColumn();
        String $ruleName = this.getRuleName();
        result = result * 59 + ($ruleName == null ? 43 : $ruleName.hashCode());
        AuditRule.Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $fixSuggestion = this.getFixSuggestion();
        result = result * 59 + ($fixSuggestion == null ? 43 : $fixSuggestion.hashCode());
        return result;
    }
}

