/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.audit.rules;

import com.autojav.core.audit.AuditResult;
import com.autojav.core.audit.AuditRule;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.List;

public class NullPointerExceptionRule
implements AuditRule {
    @Override
    public String getName() {
        return "\u7a7a\u6307\u9488\u68c0\u67e5";
    }

    @Override
    public String getDescription() {
        return "\u68c0\u67e5\u53ef\u80fd\u5bfc\u81f4\u7a7a\u6307\u9488\u5f02\u5e38\u7684\u4ee3\u7801\uff0c\u5982\u76f4\u63a5\u8c03\u7528\u53ef\u80fd\u4e3anull\u7684\u5bf9\u8c61\u65b9\u6cd5\u6216\u8bbf\u95ee\u5176\u5c5e\u6027";
    }

    @Override
    public List<AuditResult> audit(final CompilationUnit compilationUnit) {
        final ArrayList<AuditResult> results = new ArrayList<AuditResult>();
        final String filePath = compilationUnit.getStorage().map(s -> s.getPath().toString()).orElse("unknown");
        compilationUnit.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(MethodCallExpr methodCallExpr, Void arg) {
                NameExpr nameExpr;
                boolean hasNullCheck;
                super.visit(methodCallExpr, arg);
                if (methodCallExpr.getScope().isPresent() && methodCallExpr.getScope().get() instanceof NameExpr && !(hasNullCheck = NullPointerExceptionRule.this.hasNullCheck((nameExpr = (NameExpr)methodCallExpr.getScope().get()).getNameAsString(), compilationUnit))) {
                    int line = methodCallExpr.getBegin().map(b -> b.line).orElse(0);
                    int column = methodCallExpr.getBegin().map(b -> b.column).orElse(0);
                    results.add(new AuditResult(NullPointerExceptionRule.this.getName(), AuditRule.Severity.WARNING, "\u53ef\u80fd\u5b58\u5728\u7a7a\u6307\u9488\u5f02\u5e38\u98ce\u9669\uff1a\u76f4\u63a5\u8c03\u7528" + nameExpr.getNameAsString() + "\u7684\u65b9\u6cd5", filePath, line, column, "\u5efa\u8bae\u5728\u8c03\u7528\u65b9\u6cd5\u524d\u6dfb\u52a0\u7a7a\u6307\u9488\u68c0\u67e5"));
                }
            }
        }, null);
        return results;
    }

    @Override
    public AuditRule.Severity getSeverity() {
        return AuditRule.Severity.WARNING;
    }

    private boolean hasNullCheck(String variableName, CompilationUnit compilationUnit) {
        final ArrayList ifStmts = new ArrayList();
        compilationUnit.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(IfStmt ifStmt, Void arg) {
                super.visit(ifStmt, arg);
                ifStmts.add(ifStmt);
            }
        }, null);
        for (IfStmt ifStmt : ifStmts) {
            String condition = ifStmt.getCondition().toString();
            if (!condition.contains(variableName) || !condition.contains("!=") || !condition.contains("null")) continue;
            return true;
        }
        return false;
    }
}

