/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.audit.rules;

import com.autojav.core.audit.AuditResult;
import com.autojav.core.audit.AuditRule;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.List;

public class SqlInjectionRule
implements AuditRule {
    @Override
    public String getName() {
        return "SQL\u6ce8\u5165\u68c0\u67e5";
    }

    @Override
    public String getDescription() {
        return "\u68c0\u67e5\u53ef\u80fd\u5bfc\u81f4SQL\u6ce8\u5165\u7684\u4ee3\u7801\uff0c\u5982\u76f4\u63a5\u62fc\u63a5SQL\u8bed\u53e5\u800c\u4e0d\u4f7f\u7528PreparedStatement";
    }

    @Override
    public List<AuditResult> audit(CompilationUnit compilationUnit) {
        final ArrayList<AuditResult> results = new ArrayList<AuditResult>();
        final String filePath = compilationUnit.getStorage().map(s -> s.getPath().toString()).orElse("unknown");
        compilationUnit.accept(new VoidVisitorAdapter<Void>(){

            @Override
            public void visit(MethodCallExpr methodCallExpr, Void arg) {
                super.visit(methodCallExpr, arg);
                String methodName = methodCallExpr.getNameAsString();
                if (SqlInjectionRule.this.isSqlExecutionMethod(methodName)) {
                    methodCallExpr.getArguments().forEach(argExpr -> {
                        StringLiteralExpr stringLiteral;
                        String sql;
                        if (argExpr.isStringLiteralExpr() && SqlInjectionRule.this.containsSqlKeywords(sql = (stringLiteral = argExpr.asStringLiteralExpr()).getValue()) && SqlInjectionRule.this.containsConcatenation(methodCallExpr)) {
                            int line = methodCallExpr.getBegin().map(b -> b.line).orElse(0);
                            int column = methodCallExpr.getBegin().map(b -> b.column).orElse(0);
                            results.add(new AuditResult(SqlInjectionRule.this.getName(), AuditRule.Severity.ERROR, "\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669\uff1a\u76f4\u63a5\u62fc\u63a5SQL\u8bed\u53e5", filePath, line, column, "\u5efa\u8bae\u4f7f\u7528PreparedStatement\u53c2\u6570\u5316\u67e5\u8be2"));
                        }
                    });
                }
            }
        }, null);
        return results;
    }

    @Override
    public AuditRule.Severity getSeverity() {
        return AuditRule.Severity.ERROR;
    }

    private boolean isSqlExecutionMethod(String methodName) {
        String[] sqlMethods;
        for (String method : sqlMethods = new String[]{"execute", "executeQuery", "executeUpdate", "executeBatch"}) {
            if (!methodName.equals(method)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSqlKeywords(String sql) {
        String[] keywords = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "FROM", "WHERE", "AND", "OR", "ORDER", "GROUP", "JOIN"};
        String upperSql = sql.toUpperCase();
        for (String keyword : keywords) {
            if (!upperSql.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private boolean containsConcatenation(MethodCallExpr methodCallExpr) {
        return methodCallExpr.toString().contains("+");
    }
}

