/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.doc;

import com.autojav.core.doc.DocGenerationException;
import com.autojav.core.doc.DocGenerator;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownDocGenerator
implements DocGenerator {
    private static final Logger log = LoggerFactory.getLogger(MarkdownDocGenerator.class);

    @Override
    public String generate(List<CompilationUnit> compilationUnits) throws DocGenerationException {
        StringBuilder markdown = new StringBuilder();
        markdown.append("# \u63a5\u53e3\u6587\u6863\n\n");
        markdown.append("\u751f\u6210\u65f6\u95f4: " + LocalDateTime.now() + "\n\n");
        for (CompilationUnit cu : compilationUnits) {
            List<ClassOrInterfaceDeclaration> classes = cu.findAll(ClassOrInterfaceDeclaration.class);
            for (ClassOrInterfaceDeclaration clazz : classes) {
                if (!this.isController(clazz)) continue;
                markdown.append("## " + clazz.getNameAsString() + "\n\n");
                List<MethodDeclaration> methods = clazz.findAll(MethodDeclaration.class);
                for (MethodDeclaration method : methods) {
                    if (!this.isApiMethod(method)) continue;
                    markdown.append("### " + method.getNameAsString() + "\n\n");
                    String path = this.extractPath(method);
                    String methodType = this.extractMethodType(method);
                    markdown.append("**\u8def\u5f84**: `" + path + "`\n\n");
                    markdown.append("**\u65b9\u6cd5**: `" + methodType + "`\n\n");
                    NodeList<Parameter> parameters = method.getParameters();
                    if (!parameters.isEmpty()) {
                        markdown.append("**\u53c2\u6570**:\n\n");
                        markdown.append("| \u540d\u79f0 | \u7c7b\u578b | \u63cf\u8ff0 |\n");
                        markdown.append("|------|------|------|\n");
                        for (Parameter param : parameters) {
                            String paramName = param.getNameAsString();
                            String paramType = param.getTypeAsString();
                            String paramDesc = this.extractParamDescription(param);
                            markdown.append("| " + paramName + " | " + paramType + " | " + paramDesc + " |\n");
                        }
                        markdown.append("\n");
                    }
                    String returnType = method.getTypeAsString();
                    markdown.append("**\u8fd4\u56de\u7c7b\u578b**: `" + returnType + "`\n\n");
                    String methodDesc = this.extractMethodDescription(method);
                    if (!methodDesc.isEmpty()) {
                        markdown.append("**\u63cf\u8ff0**: " + methodDesc + "\n\n");
                    }
                    markdown.append("---\n\n");
                }
            }
        }
        return markdown.toString();
    }

    @Override
    public void generateAndSave(List<CompilationUnit> compilationUnits, File outputFile) throws DocGenerationException {
        try {
            String markdown = this.generate(compilationUnits);
            Files.writeString(outputFile.toPath(), (CharSequence)markdown, new OpenOption[0]);
            log.info("Markdown\u6587\u6863\u751f\u6210\u6210\u529f: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58Markdown\u6587\u6863\u5931\u8d25", e);
            throw new DocGenerationException("\u4fdd\u5b58Markdown\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public String getFormat() {
        return "markdown";
    }

    private boolean isController(ClassOrInterfaceDeclaration clazz) {
        return clazz.getAnnotations().stream().anyMatch(annotation -> annotation.getNameAsString().equals("RestController") || annotation.getNameAsString().equals("Controller"));
    }

    private boolean isApiMethod(MethodDeclaration method) {
        return method.getAnnotations().stream().anyMatch(annotation -> annotation.getNameAsString().equals("GetMapping") || annotation.getNameAsString().equals("PostMapping") || annotation.getNameAsString().equals("PutMapping") || annotation.getNameAsString().equals("DeleteMapping") || annotation.getNameAsString().equals("PatchMapping"));
    }

    private String extractPath(MethodDeclaration method) {
        for (AnnotationExpr annotation : method.getAnnotations()) {
            String annotationName = annotation.getNameAsString();
            if (!annotationName.endsWith("Mapping")) continue;
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr singleMemberAnnotation = (SingleMemberAnnotationExpr)annotation;
                return singleMemberAnnotation.getMemberValue().toString().replace("\"", "");
            }
            if (!(annotation instanceof NormalAnnotationExpr)) continue;
            NormalAnnotationExpr normalAnnotation = (NormalAnnotationExpr)annotation;
            for (MemberValuePair pair : normalAnnotation.getPairs()) {
                if (!pair.getNameAsString().equals("value")) continue;
                return pair.getValue().toString().replace("\"", "");
            }
        }
        return "/" + method.getNameAsString();
    }

    private String extractMethodType(MethodDeclaration method) {
        for (AnnotationExpr annotation : method.getAnnotations()) {
            String annotationName;
            switch (annotationName = annotation.getNameAsString()) {
                case "GetMapping": {
                    return "GET";
                }
                case "PostMapping": {
                    return "POST";
                }
                case "PutMapping": {
                    return "PUT";
                }
                case "DeleteMapping": {
                    return "DELETE";
                }
                case "PatchMapping": {
                    return "PATCH";
                }
            }
        }
        return "GET";
    }

    private String extractParamDescription(Parameter parameter) {
        return "";
    }

    private String extractMethodDescription(MethodDeclaration method) {
        return "";
    }
}

