/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.doc;

import com.autojav.core.doc.DocGenerationException;
import com.autojav.core.doc.DocGenerator;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiDocGenerator
implements DocGenerator {
    private static final Logger log = LoggerFactory.getLogger(OpenApiDocGenerator.class);

    @Override
    public String generate(List<CompilationUnit> compilationUnits) throws DocGenerationException {
        StringBuilder openapi = new StringBuilder();
        openapi.append("openapi: 3.0.0\n");
        openapi.append("info:\n");
        openapi.append("  title: \u63a5\u53e3\u6587\u6863\n");
        openapi.append("  version: 1.0.0\n");
        openapi.append("  description: \u81ea\u52a8\u751f\u6210\u7684\u63a5\u53e3\u6587\u6863\n");
        openapi.append("paths:\n");
        for (CompilationUnit cu : compilationUnits) {
            List<ClassOrInterfaceDeclaration> classes = cu.findAll(ClassOrInterfaceDeclaration.class);
            for (ClassOrInterfaceDeclaration clazz : classes) {
                if (!this.isController(clazz)) continue;
                String classPath = this.extractClassPath(clazz);
                List<MethodDeclaration> methods = clazz.findAll(MethodDeclaration.class);
                for (MethodDeclaration method : methods) {
                    if (!this.isApiMethod(method)) continue;
                    String methodPath = this.extractPath(method);
                    String fullPath = classPath + methodPath;
                    String methodType = this.extractMethodType(method).toLowerCase();
                    openapi.append("  '" + fullPath + "':\n");
                    openapi.append("    " + methodType + " :\n");
                    openapi.append("      summary: " + method.getNameAsString() + "\n");
                    openapi.append("      description: " + this.extractMethodDescription(method) + "\n");
                    openapi.append("      parameters:\n");
                    NodeList<Parameter> parameters = method.getParameters();
                    for (Parameter param : parameters) {
                        String paramName = param.getNameAsString();
                        String paramType = param.getTypeAsString();
                        openapi.append("        - name: " + paramName + "\n");
                        openapi.append("          in: query\n");
                        openapi.append("          required: false\n");
                        openapi.append("          schema:\n");
                        openapi.append("            type: " + this.mapJavaTypeToOpenApiType(paramType) + "\n");
                    }
                    openapi.append("      responses:\n");
                    openapi.append("        '200':\n");
                    openapi.append("          description: \u6210\u529f\n");
                    openapi.append("          content:\n");
                    openapi.append("            application/json:\n");
                    openapi.append("              schema:\n");
                    openapi.append("                type: object\n");
                }
            }
        }
        return openapi.toString();
    }

    @Override
    public void generateAndSave(List<CompilationUnit> compilationUnits, File outputFile) throws DocGenerationException {
        try {
            String openapi = outputFile.getName().endsWith(".json") ? this.generateJson(compilationUnits) : this.generate(compilationUnits);
            Files.writeString(outputFile.toPath(), (CharSequence)openapi, new OpenOption[0]);
            log.info("OpenAPI\u6587\u6863\u751f\u6210\u6210\u529f: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58OpenAPI\u6587\u6863\u5931\u8d25", e);
            throw new DocGenerationException("\u4fdd\u5b58OpenAPI\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private String generateJson(List<CompilationUnit> compilationUnits) throws DocGenerationException {
        StringBuilder openapi = new StringBuilder();
        openapi.append("{");
        openapi.append("\"openapi\": \"3.0.0\",");
        openapi.append("\"info\": {");
        openapi.append("\"title\": \"\u63a5\u53e3\u6587\u6863\",");
        openapi.append("\"version\": \"1.0.0\",");
        openapi.append("\"description\": \"\u81ea\u52a8\u751f\u6210\u7684\u63a5\u53e3\u6587\u6863\"");
        openapi.append("},");
        openapi.append("\"paths\": {");
        boolean firstPath = true;
        for (CompilationUnit cu : compilationUnits) {
            List<ClassOrInterfaceDeclaration> classes = cu.findAll(ClassOrInterfaceDeclaration.class);
            for (ClassOrInterfaceDeclaration clazz : classes) {
                if (!this.isController(clazz)) continue;
                String classPath = this.extractClassPath(clazz);
                List<MethodDeclaration> methods = clazz.findAll(MethodDeclaration.class);
                for (MethodDeclaration method : methods) {
                    if (!this.isApiMethod(method)) continue;
                    String methodPath = this.extractPath(method);
                    String fullPath = classPath + methodPath;
                    String methodType = this.extractMethodType(method).toLowerCase();
                    if (!firstPath) {
                        openapi.append(",");
                    }
                    firstPath = false;
                    openapi.append("\"" + fullPath + "\": {");
                    openapi.append("\"" + methodType + "\": {");
                    openapi.append("\"summary\": \"" + method.getNameAsString() + "\",");
                    openapi.append("\"description\": \"" + this.extractMethodDescription(method) + "\",");
                    openapi.append("\"parameters\": [");
                    NodeList<Parameter> parameters = method.getParameters();
                    for (int j = 0; j < parameters.size(); ++j) {
                        Parameter param = (Parameter)parameters.get(j);
                        String paramName = param.getNameAsString();
                        String paramType = param.getTypeAsString();
                        if (j > 0) {
                            openapi.append(",");
                        }
                        openapi.append("{");
                        openapi.append("\"name\": \"" + paramName + "\",");
                        openapi.append("\"in\": \"query\",");
                        openapi.append("\"required\": false,");
                        openapi.append("\"schema\": {");
                        openapi.append("\"type\": \"" + this.mapJavaTypeToOpenApiType(paramType) + "\"");
                        openapi.append("}");
                        openapi.append("}");
                    }
                    openapi.append("] ,");
                    openapi.append("\"responses\": {");
                    openapi.append("\"200\": {");
                    openapi.append("\"description\": \"\u6210\u529f\",");
                    openapi.append("\"content\": {");
                    openapi.append("\"application/json\": {");
                    openapi.append("\"schema\": {");
                    openapi.append("\"type\": \"object\"");
                    openapi.append("}");
                    openapi.append("}");
                    openapi.append("}");
                    openapi.append("}");
                    openapi.append("}");
                    openapi.append("}");
                    openapi.append("}");
                }
            }
        }
        openapi.append("}");
        openapi.append("}");
        return openapi.toString();
    }

    @Override
    public String getFormat() {
        return "openapi";
    }

    private boolean isController(ClassOrInterfaceDeclaration clazz) {
        return clazz.getAnnotations().stream().anyMatch(annotation -> annotation.getNameAsString().equals("RestController") || annotation.getNameAsString().equals("Controller"));
    }

    private boolean isApiMethod(MethodDeclaration method) {
        return method.getAnnotations().stream().anyMatch(annotation -> annotation.getNameAsString().equals("GetMapping") || annotation.getNameAsString().equals("PostMapping") || annotation.getNameAsString().equals("PutMapping") || annotation.getNameAsString().equals("DeleteMapping") || annotation.getNameAsString().equals("PatchMapping"));
    }

    private String extractClassPath(ClassOrInterfaceDeclaration clazz) {
        for (AnnotationExpr annotation : clazz.getAnnotations()) {
            if (!annotation.getNameAsString().equals("RequestMapping")) continue;
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr singleMemberAnnotation = (SingleMemberAnnotationExpr)annotation;
                return singleMemberAnnotation.getMemberValue().toString().replace("\"", "");
            }
            if (!(annotation instanceof NormalAnnotationExpr)) continue;
            NormalAnnotationExpr normalAnnotation = (NormalAnnotationExpr)annotation;
            for (MemberValuePair pair : normalAnnotation.getPairs()) {
                if (!pair.getNameAsString().equals("value")) continue;
                return pair.getValue().toString().replace("\"", "");
            }
        }
        return "/";
    }

    private String extractPath(MethodDeclaration method) {
        for (AnnotationExpr annotation : method.getAnnotations()) {
            String annotationName = annotation.getNameAsString();
            if (!annotationName.endsWith("Mapping")) continue;
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr singleMemberAnnotation = (SingleMemberAnnotationExpr)annotation;
                return singleMemberAnnotation.getMemberValue().toString().replace("\"", "");
            }
            if (!(annotation instanceof NormalAnnotationExpr)) continue;
            NormalAnnotationExpr normalAnnotation = (NormalAnnotationExpr)annotation;
            for (MemberValuePair pair : normalAnnotation.getPairs()) {
                if (!pair.getNameAsString().equals("value")) continue;
                return pair.getValue().toString().replace("\"", "");
            }
        }
        return "/" + method.getNameAsString();
    }

    private String extractMethodType(MethodDeclaration method) {
        for (AnnotationExpr annotation : method.getAnnotations()) {
            String annotationName;
            switch (annotationName = annotation.getNameAsString()) {
                case "GetMapping": {
                    return "GET";
                }
                case "PostMapping": {
                    return "POST";
                }
                case "PutMapping": {
                    return "PUT";
                }
                case "DeleteMapping": {
                    return "DELETE";
                }
                case "PatchMapping": {
                    return "PATCH";
                }
            }
        }
        return "GET";
    }

    private String extractMethodDescription(MethodDeclaration method) {
        return "";
    }

    private String mapJavaTypeToOpenApiType(String javaType) {
        switch (javaType) {
            case "int": 
            case "Integer": {
                return "integer";
            }
            case "long": 
            case "Long": {
                return "integer";
            }
            case "float": 
            case "Float": 
            case "double": 
            case "Double": {
                return "number";
            }
            case "boolean": 
            case "Boolean": {
                return "boolean";
            }
            case "String": {
                return "string";
            }
        }
        return "object";
    }
}

