/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.fix;

import com.autojav.core.TerminalUtils;
import com.autojav.core.ai.AIException;
import com.autojav.core.ai.AIService;
import com.autojav.core.ai.AIServiceFactory;
import com.autojav.core.fix.FixResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixManager {
    private static final Logger log = LoggerFactory.getLogger(FixManager.class);
    private AIService aiService;

    public FixManager(String apiKey) {
        this.aiService = AIServiceFactory.createAIService(apiKey);
    }

    public FixManager(AIService aiService) {
        this.aiService = aiService;
    }

    public FixResult fixCode(File file, String issues, boolean preview) throws Exception {
        String originalCode = Files.readString(file.toPath());
        try {
            String fixedCode = this.aiService.fixCode(originalCode, issues);
            fixedCode = this.extractCode(fixedCode);
            if (preview) {
                return new FixResult(file, originalCode, fixedCode, true, false);
            }
            File backupFile = this.createBackupFile(file);
            Files.writeString(file.toPath(), (CharSequence)fixedCode, new OpenOption[0]);
            return new FixResult(file, originalCode, fixedCode, false, true, backupFile);
        }
        catch (AIException e) {
            log.error("AI\u4fee\u590d\u5931\u8d25", e);
            throw new Exception("AI\u4fee\u590d\u5931\u8d25: " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            throw new Exception("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private File createBackupFile(File originalFile) throws IOException {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String backupFileName = originalFile.getName().replace(".java", ".backup." + timestamp + ".java");
        File backupFile = new File(originalFile.getParent(), backupFileName);
        Files.copy(originalFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        log.info("\u521b\u5efa\u5907\u4efd\u6587\u4ef6: {}", (Object)backupFile.getAbsolutePath());
        return backupFile;
    }

    private String extractCode(String content) {
        content = content.replaceAll("```java\\n", "");
        content = content.replaceAll("```\\n", "");
        content = content.replaceAll("```", "");
        return content.trim();
    }

    public void showPreview(FixResult result) {
        TerminalUtils.printInfo("\u4fee\u590d\u9884\u89c8:");
        TerminalUtils.printInfo("\u6587\u4ef6: " + result.getFile().getName());
        TerminalUtils.printInfo("\n\u539f\u59cb\u4ee3\u7801:");
        TerminalUtils.printInfo(result.getOriginalCode());
        TerminalUtils.printInfo("\n\u4fee\u590d\u540e\u4ee3\u7801:");
        TerminalUtils.printInfo(result.getFixedCode());
    }

    public void rollback(FixResult result) throws IOException {
        if (result.isApplied() && result.getBackupFile() != null) {
            Files.copy(result.getBackupFile().toPath(), result.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            TerminalUtils.printSuccess("\u4fee\u590d\u5df2\u56de\u6eda\uff0c\u6587\u4ef6\u5df2\u6062\u590d\u5230\u539f\u59cb\u72b6\u6001");
            log.info("\u56de\u6eda\u4fee\u590d: {}", (Object)result.getFile().getAbsolutePath());
        } else {
            TerminalUtils.printError("\u65e0\u6cd5\u56de\u6eda\uff0c\u4fee\u590d\u672a\u5e94\u7528\u6216\u6ca1\u6709\u5907\u4efd\u6587\u4ef6");
        }
    }
}

