/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.fix;

import java.io.File;

public class FixResult {
    private File file;
    private String originalCode;
    private String fixedCode;
    private boolean preview;
    private boolean applied;
    private File backupFile;

    public FixResult(File file, String originalCode, String fixedCode, boolean preview, boolean applied) {
        this.file = file;
        this.originalCode = originalCode;
        this.fixedCode = fixedCode;
        this.preview = preview;
        this.applied = applied;
    }

    public FixResult(File file, String originalCode, String fixedCode, boolean preview, boolean applied, File backupFile) {
        this(file, originalCode, fixedCode, preview, applied);
        this.backupFile = backupFile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u4fee\u590d\u7ed3\u679c:\n");
        sb.append("\u6587\u4ef6: ").append(this.file.getName()).append("\n");
        sb.append("\u72b6\u6001: ").append(this.applied ? "\u5df2\u5e94\u7528" : "\u9884\u89c8").append("\n");
        if (this.backupFile != null) {
            sb.append("\u5907\u4efd\u6587\u4ef6: ").append(this.backupFile.getName()).append("\n");
        }
        sb.append("\u4fee\u590d\u524d\u540e\u4ee3\u7801\u5dee\u5f02: \n");
        String[] originalLines = this.originalCode.split("\\n");
        String[] fixedLines = this.fixedCode.split("\\n");
        int maxLines = Math.max(originalLines.length, fixedLines.length);
        for (int i = 0; i < maxLines; ++i) {
            if (i < originalLines.length && i < fixedLines.length) {
                if (!originalLines[i].equals(fixedLines[i])) {
                    sb.append("- ").append(originalLines[i]).append("\n");
                    sb.append("+ ").append(fixedLines[i]).append("\n");
                    continue;
                }
                sb.append("  ").append(originalLines[i]).append("\n");
                continue;
            }
            if (i < originalLines.length) {
                sb.append("- ").append(originalLines[i]).append("\n");
                continue;
            }
            sb.append("+ ").append(fixedLines[i]).append("\n");
        }
        return sb.toString();
    }

    public File getFile() {
        return this.file;
    }

    public String getOriginalCode() {
        return this.originalCode;
    }

    public String getFixedCode() {
        return this.fixedCode;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOriginalCode(String originalCode) {
        this.originalCode = originalCode;
    }

    public void setFixedCode(String fixedCode) {
        this.fixedCode = fixedCode;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public void setBackupFile(File backupFile) {
        this.backupFile = backupFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixResult)) {
            return false;
        }
        FixResult other = (FixResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreview() != other.isPreview()) {
            return false;
        }
        if (this.isApplied() != other.isApplied()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$originalCode = this.getOriginalCode();
        String other$originalCode = other.getOriginalCode();
        if (this$originalCode == null ? other$originalCode != null : !this$originalCode.equals(other$originalCode)) {
            return false;
        }
        String this$fixedCode = this.getFixedCode();
        String other$fixedCode = other.getFixedCode();
        if (this$fixedCode == null ? other$fixedCode != null : !this$fixedCode.equals(other$fixedCode)) {
            return false;
        }
        File this$backupFile = this.getBackupFile();
        File other$backupFile = other.getBackupFile();
        return !(this$backupFile == null ? other$backupFile != null : !((Object)this$backupFile).equals(other$backupFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreview() ? 79 : 97);
        result = result * 59 + (this.isApplied() ? 79 : 97);
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $originalCode = this.getOriginalCode();
        result = result * 59 + ($originalCode == null ? 43 : $originalCode.hashCode());
        String $fixedCode = this.getFixedCode();
        result = result * 59 + ($fixedCode == null ? 43 : $fixedCode.hashCode());
        File $backupFile = this.getBackupFile();
        result = result * 59 + ($backupFile == null ? 43 : ((Object)$backupFile).hashCode());
        return result;
    }
}

