/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.license;

import com.autojav.core.license.VersionType;
import java.util.HashMap;
import java.util.Map;

public class FeaturePermissions {
    private Map<String, Boolean> permissions = new HashMap<String, Boolean>();

    public FeaturePermissions() {
        this.initDefaultPermissions();
    }

    public FeaturePermissions(VersionType versionType) {
        this.initDefaultPermissions();
        this.initVersionPermissions(versionType);
    }

    private void initDefaultPermissions() {
        this.permissions.put("code.audit", true);
        this.permissions.put("doc.generate", true);
        this.permissions.put("config.manage", true);
        this.permissions.put("code.fix", false);
        this.permissions.put("ai.audit", false);
        this.permissions.put("custom.template", false);
        this.permissions.put("team.collab", false);
        this.permissions.put("private.deploy", false);
        this.permissions.put("ci.cd.integration", false);
    }

    private void initVersionPermissions(VersionType versionType) {
        switch (versionType) {
            case FREE: {
                break;
            }
            case TEAM: {
                this.permissions.put("code.fix", true);
                this.permissions.put("ai.audit", true);
                this.permissions.put("team.collab", true);
                break;
            }
            case ENTERPRISE: {
                this.permissions.put("code.fix", true);
                this.permissions.put("ai.audit", true);
                this.permissions.put("custom.template", true);
                this.permissions.put("team.collab", true);
                this.permissions.put("private.deploy", true);
                this.permissions.put("ci.cd.integration", true);
                break;
            }
            case PERPETUAL: {
                this.permissions.put("code.fix", true);
                this.permissions.put("ai.audit", true);
                this.permissions.put("custom.template", true);
                this.permissions.put("team.collab", true);
                this.permissions.put("private.deploy", true);
                this.permissions.put("ci.cd.integration", true);
            }
        }
    }

    public boolean hasPermission(String feature) {
        return this.permissions.getOrDefault(feature, false);
    }

    public void setPermission(String feature, boolean allowed) {
        this.permissions.put(feature, allowed);
    }

    public Map<String, Boolean> getAllPermissions() {
        return this.permissions;
    }

    public static boolean isFreeFeature(String feature) {
        return "code.audit".equals(feature) || "doc.generate".equals(feature) || "config.manage".equals(feature);
    }
}

