/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.license;

import com.autojav.core.license.FeaturePermissions;
import com.autojav.core.license.VersionType;
import java.time.LocalDateTime;

public class License {
    private String licenseId;
    private VersionType versionType;
    private LocalDateTime startTime;
    private LocalDateTime expireTime;
    private FeaturePermissions permissions;
    private LicenseStatus status;
    private boolean trial = false;
    private String machineFingerprint;

    public boolean isValid() {
        if (this.status != LicenseStatus.ACTIVE) {
            return false;
        }
        LocalDateTime now = LocalDateTime.now();
        return now.isAfter(this.startTime) && now.isBefore(this.expireTime);
    }

    public boolean hasPermission(String feature) {
        if (!this.isValid()) {
            return false;
        }
        return this.permissions.hasPermission(feature);
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public FeaturePermissions getPermissions() {
        return this.permissions;
    }

    public LicenseStatus getStatus() {
        return this.status;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public String getMachineFingerprint() {
        return this.machineFingerprint;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public void setVersionType(VersionType versionType) {
        this.versionType = versionType;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public void setPermissions(FeaturePermissions permissions) {
        this.permissions = permissions;
    }

    public void setStatus(LicenseStatus status) {
        this.status = status;
    }

    public void setTrial(boolean trial) {
        this.trial = trial;
    }

    public void setMachineFingerprint(String machineFingerprint) {
        this.machineFingerprint = machineFingerprint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTrial() != other.isTrial()) {
            return false;
        }
        String this$licenseId = this.getLicenseId();
        String other$licenseId = other.getLicenseId();
        if (this$licenseId == null ? other$licenseId != null : !this$licenseId.equals(other$licenseId)) {
            return false;
        }
        VersionType this$versionType = this.getVersionType();
        VersionType other$versionType = other.getVersionType();
        if (this$versionType == null ? other$versionType != null : !((Object)((Object)this$versionType)).equals((Object)other$versionType)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$expireTime = this.getExpireTime();
        LocalDateTime other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        FeaturePermissions this$permissions = this.getPermissions();
        FeaturePermissions other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) {
            return false;
        }
        LicenseStatus this$status = this.getStatus();
        LicenseStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$machineFingerprint = this.getMachineFingerprint();
        String other$machineFingerprint = other.getMachineFingerprint();
        return !(this$machineFingerprint == null ? other$machineFingerprint != null : !this$machineFingerprint.equals(other$machineFingerprint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof License;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrial() ? 79 : 97);
        String $licenseId = this.getLicenseId();
        result = result * 59 + ($licenseId == null ? 43 : $licenseId.hashCode());
        VersionType $versionType = this.getVersionType();
        result = result * 59 + ($versionType == null ? 43 : ((Object)((Object)$versionType)).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        FeaturePermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
        LicenseStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $machineFingerprint = this.getMachineFingerprint();
        result = result * 59 + ($machineFingerprint == null ? 43 : $machineFingerprint.hashCode());
        return result;
    }

    public String toString() {
        return "License(licenseId=" + this.getLicenseId() + ", versionType=" + this.getVersionType() + ", startTime=" + this.getStartTime() + ", expireTime=" + this.getExpireTime() + ", permissions=" + this.getPermissions() + ", status=" + this.getStatus() + ", trial=" + this.isTrial() + ", machineFingerprint=" + this.getMachineFingerprint() + ")";
    }

    public static enum LicenseStatus {
        ACTIVE("\u6fc0\u6d3b"),
        TRIAL("\u8bd5\u7528\u4e2d"),
        EXPIRED("\u8fc7\u671f"),
        REVOKED("\u5df2\u64a4\u9500"),
        INVALID("\u65e0\u6548");

        private final String name;

        private LicenseStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

