/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.license;

import com.autojav.core.license.LicenseValidator;
import com.autojav.core.license.VersionType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Scanner;

public class LicenseGenerator {
    public static void main(String[] args2) {
        String machineFingerprint;
        LocalDateTime expireTime;
        VersionType versionType;
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551     AutoJava License Generator         \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println();
        Scanner scanner = new Scanner(System.in);
        System.out.println("\u9009\u62e9\u7248\u672c\u7c7b\u578b:");
        System.out.println("  1. \u56e2\u961f\u7248 (TEAM)");
        System.out.println("  2. \u4f01\u4e1a\u7248 (ENTERPRISE)");
        System.out.println("  3. \u4e70\u65ad\u7248 (PERPETUAL)");
        System.out.print("\u8bf7\u8f93\u5165\u9009\u9879 (1-3): ");
        int versionChoice = scanner.nextInt();
        scanner.nextLine();
        switch (versionChoice) {
            case 1: {
                versionType = VersionType.TEAM;
                break;
            }
            case 2: {
                versionType = VersionType.ENTERPRISE;
                break;
            }
            case 3: {
                versionType = VersionType.PERPETUAL;
                break;
            }
            default: {
                System.out.println("\u65e0\u6548\u9009\u9879");
                return;
            }
        }
        System.out.println();
        System.out.println("\u9009\u62e9\u6709\u6548\u671f:");
        System.out.println("  1. 1\u5e74");
        System.out.println("  2. 2\u5e74");
        System.out.println("  3. 3\u5e74");
        System.out.println("  4. \u6c38\u4e45\uff08\u4ec5\u4e70\u65ad\u7248\uff09");
        System.out.println("  5. \u81ea\u5b9a\u4e49\u5929\u6570");
        System.out.print("\u8bf7\u8f93\u5165\u9009\u9879 (1-5): ");
        int durationChoice = scanner.nextInt();
        scanner.nextLine();
        switch (durationChoice) {
            case 1: {
                expireTime = LocalDateTime.now().plusYears(1L);
                break;
            }
            case 2: {
                expireTime = LocalDateTime.now().plusYears(2L);
                break;
            }
            case 3: {
                expireTime = LocalDateTime.now().plusYears(3L);
                break;
            }
            case 4: {
                if (versionType != VersionType.PERPETUAL) {
                    System.out.println("\u6c38\u4e45\u6709\u6548\u671f\u4ec5\u9002\u7528\u4e8e\u4e70\u65ad\u7248");
                    return;
                }
                expireTime = LocalDateTime.now().plusYears(100L);
                break;
            }
            case 5: {
                System.out.print("\u8bf7\u8f93\u5165\u5929\u6570: ");
                int days = scanner.nextInt();
                scanner.nextLine();
                expireTime = LocalDateTime.now().plusDays(days);
                break;
            }
            default: {
                System.out.println("\u65e0\u6548\u9009\u9879");
                return;
            }
        }
        System.out.println();
        System.out.print("\u662f\u5426\u7ed1\u5b9a\u7279\u5b9a\u673a\u5668? (y/n): ");
        String bindChoice = scanner.nextLine().trim().toLowerCase();
        if (bindChoice.equals("y")) {
            System.out.print("\u8bf7\u8f93\u5165\u673a\u5668\u6307\u7eb9: ");
            machineFingerprint = scanner.nextLine().trim();
        } else {
            machineFingerprint = "ANY";
        }
        System.out.println();
        System.out.println("\u6b63\u5728\u751f\u6210\u8bb8\u53ef\u8bc1...");
        String licenseKey = LicenseValidator.generateLicenseKey(versionType, expireTime, machineFingerprint);
        System.out.println();
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551              \u8bb8\u53ef\u8bc1\u751f\u6210\u6210\u529f                            \u2551");
        System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        System.out.println("\u2551 \u7248\u672c\u7c7b\u578b: " + LicenseGenerator.padRight(versionType.getName(), 41) + "\u2551");
        System.out.println("\u2551 \u6709\u6548\u671f\u81f3: " + LicenseGenerator.padRight(expireTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), 41) + "\u2551");
        System.out.println("\u2551 \u673a\u5668\u7ed1\u5b9a: " + LicenseGenerator.padRight(machineFingerprint.equals("ANY") ? "\u4e0d\u9650" : machineFingerprint, 41) + "\u2551");
        System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        System.out.println("\u2551 \u8bb8\u53ef\u8bc1\u5bc6\u94a5 (\u8bf7\u590d\u5236\u7ed9\u5ba2\u6237):                             \u2551");
        System.out.println("\u2551 " + LicenseGenerator.padRight(licenseKey, 52) + " \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println();
        System.out.println("\u6fc0\u6d3b\u547d\u4ee4:");
        System.out.println("  autojav license activate " + licenseKey);
    }

    private static String padRight(String s, int n) {
        if (s.length() > n) {
            return s.substring(0, n);
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < n) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

