/*
 * Decompiled with CFR 0.152.
 */
package com.autojav.core.license;

import com.autojav.core.license.FeaturePermissions;
import com.autojav.core.license.License;
import com.autojav.core.license.VersionType;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseValidator {
    private static final Logger log = LoggerFactory.getLogger(LicenseValidator.class);
    private static final String SECRET_KEY = "AutoJava2026#License";
    private static final String SIGNATURE_PREFIX = "AJV:";

    public static ValidationResult validate(String licenseKey) {
        if (licenseKey == null || licenseKey.trim().isEmpty()) {
            return ValidationResult.fail("\u8bb8\u53ef\u8bc1\u5bc6\u94a5\u4e3a\u7a7a");
        }
        try {
            String currentFingerprint;
            VersionType versionType;
            String decrypted = LicenseValidator.decrypt(licenseKey);
            if (!decrypted.startsWith(SIGNATURE_PREFIX)) {
                return ValidationResult.fail("\u65e0\u6548\u7684\u8bb8\u53ef\u8bc1\u683c\u5f0f");
            }
            String[] parts = decrypted.substring(SIGNATURE_PREFIX.length()).split(":");
            if (parts.length < 4) {
                return ValidationResult.fail("\u8bb8\u53ef\u8bc1\u6570\u636e\u4e0d\u5b8c\u6574");
            }
            String versionTypeStr = parts[0];
            String expireTimeStr = parts[1];
            String machineFingerprint = parts[2];
            String signature = parts[3];
            try {
                versionType = VersionType.valueOf(versionTypeStr);
            }
            catch (IllegalArgumentException e) {
                return ValidationResult.fail("\u672a\u77e5\u7684\u8bb8\u53ef\u8bc1\u7248\u672c");
            }
            LocalDateTime expireTime = LocalDateTime.parse(expireTimeStr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            if (LocalDateTime.now().isAfter(expireTime)) {
                return ValidationResult.fail("\u8bb8\u53ef\u8bc1\u5df2\u8fc7\u671f");
            }
            if (!(machineFingerprint.isEmpty() || machineFingerprint.equals("ANY") || machineFingerprint.equals(currentFingerprint = LicenseValidator.getMachineFingerprint()))) {
                return ValidationResult.fail("\u8bb8\u53ef\u8bc1\u4e0e\u5f53\u524d\u8bbe\u5907\u4e0d\u5339\u914d");
            }
            String dataToSign = versionTypeStr + ":" + expireTimeStr + ":" + machineFingerprint;
            String expectedSignature = LicenseValidator.generateSignature(dataToSign);
            if (!expectedSignature.equals(signature)) {
                return ValidationResult.fail("\u8bb8\u53ef\u8bc1\u7b7e\u540d\u65e0\u6548\uff0c\u53ef\u80fd\u5df2\u88ab\u7be1\u6539");
            }
            License license = new License();
            license.setLicenseId(licenseKey.substring(0, Math.min(16, licenseKey.length())));
            license.setVersionType(versionType);
            license.setStartTime(LocalDateTime.now().minusDays(1L));
            license.setExpireTime(expireTime);
            license.setMachineFingerprint(machineFingerprint);
            license.setPermissions(new FeaturePermissions(versionType));
            license.setStatus(License.LicenseStatus.ACTIVE);
            return ValidationResult.success(license);
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u8bb8\u53ef\u8bc1\u5931\u8d25", e);
            return ValidationResult.fail("\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage());
        }
    }

    public static String generateLicenseKey(VersionType versionType, LocalDateTime expireTime, String machineFingerprint) {
        try {
            String fp = machineFingerprint != null ? machineFingerprint : "ANY";
            String dataToSign = versionType.name() + ":" + expireTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ":" + fp;
            String signature = LicenseValidator.generateSignature(dataToSign);
            String licenseData = SIGNATURE_PREFIX + versionType.name() + ":" + expireTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ":" + fp + ":" + signature;
            return LicenseValidator.encrypt(licenseData);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u8bb8\u53ef\u8bc1\u5931\u8d25", e);
            throw new RuntimeException("\u751f\u6210\u8bb8\u53ef\u8bc1\u5931\u8d25", e);
        }
    }

    public static String generateTrialLicense() {
        LocalDateTime expireTime = LocalDateTime.now().plusDays(7L);
        return LicenseValidator.generateLicenseKey(VersionType.TEAM, expireTime, "ANY");
    }

    public static String getMachineFingerprint() {
        try {
            String userName = System.getProperty("user.name");
            String osName = System.getProperty("os.name");
            String machineName = InetAddress.getLocalHost().getHostName();
            String combined = userName + "@" + machineName + "#" + osName;
            return LicenseValidator.hash(combined).substring(0, 16);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u673a\u5668\u6307\u7eb9\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u6307\u7eb9", e);
            return "UNKNOWN";
        }
    }

    private static String encrypt(String data) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(LicenseValidator.getKeyBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, keySpec);
        byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private static String decrypt(String encryptedData) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(LicenseValidator.getKeyBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, keySpec);
        byte[] decoded = Base64.getDecoder().decode(encryptedData);
        byte[] decrypted = cipher.doFinal(decoded);
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    private static String generateSignature(String data) {
        return LicenseValidator.hash(data + SECRET_KEY).substring(0, 16);
    }

    private static String hash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getKeyBytes() {
        byte[] keyBytes = SECRET_KEY.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[16];
        System.arraycopy(keyBytes, 0, key, 0, Math.min(keyBytes.length, 16));
        return key;
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String message;
        private final License license;

        private ValidationResult(boolean valid, String message, License license) {
            this.valid = valid;
            this.message = message;
            this.license = license;
        }

        public static ValidationResult success(License license) {
            return new ValidationResult(true, "\u9a8c\u8bc1\u6210\u529f", license);
        }

        public static ValidationResult fail(String message) {
            return new ValidationResult(false, message, null);
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }

        public License getLicense() {
            return this.license;
        }
    }
}

