/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.logic;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class FunctionalInterfaceLogic {
    private static String JAVA_LANG_FUNCTIONAL_INTERFACE = FunctionalInterface.class.getCanonicalName();
    private static List<String> OBJECT_PUBLIC_METHODS_SIGNATURES = Arrays.stream(Object.class.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).map(method -> FunctionalInterfaceLogic.getSignature(method)).collect(Collectors.toList());

    private FunctionalInterfaceLogic() {
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration();
        if (!optionalTypeDeclaration.isPresent()) {
            return Optional.empty();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = optionalTypeDeclaration.get();
        if (type.isReferenceType() && typeDeclaration.isInterface()) {
            return FunctionalInterfaceLogic.getFunctionalMethod(typeDeclaration);
        }
        return Optional.empty();
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedReferenceTypeDeclaration typeDeclaration) {
        Set methods = typeDeclaration.getAllMethods().stream().filter(m -> m.getDeclaration().isAbstract()).filter(m -> !FunctionalInterfaceLogic.isPublicMemberOfObject(m)).collect(Collectors.toSet());
        if (methods.size() == 0) {
            return Optional.empty();
        }
        Iterator iterator2 = methods.iterator();
        MethodUsage methodUsage = (MethodUsage)iterator2.next();
        while (iterator2.hasNext()) {
            MethodUsage otherMethodUsage = (MethodUsage)iterator2.next();
            if (!(methodUsage.isSameSignature(otherMethodUsage) || methodUsage.isSubSignature(otherMethodUsage) || otherMethodUsage.isSubSignature(methodUsage))) {
                methodUsage = null;
                break;
            }
            if (methodUsage.isReturnTypeSubstituable(otherMethodUsage)) continue;
            methodUsage = null;
            break;
        }
        return Optional.ofNullable(methodUsage);
    }

    public static boolean isFunctionalInterfaceType(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration;
        if (type.isReferenceType() && (optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration()).isPresent() && optionalTypeDeclaration.get().hasAnnotation(JAVA_LANG_FUNCTIONAL_INTERFACE)) {
            return true;
        }
        return FunctionalInterfaceLogic.getFunctionalMethod(type).isPresent();
    }

    private static String getSignature(Method m) {
        return String.format("%s(%s)", m.getName(), String.join((CharSequence)", ", Arrays.stream(m.getParameters()).map(p -> FunctionalInterfaceLogic.toSignature(p)).collect(Collectors.toList())));
    }

    private static String toSignature(Parameter p) {
        return p.getType().getCanonicalName();
    }

    private static boolean isPublicMemberOfObject(MethodUsage m) {
        return OBJECT_PUBLIC_METHODS_SIGNATURES.contains(m.getDeclaration().getSignature());
    }
}

